---
description: "Learn more about: Statistical functions"
title: "Statistical functions (DAX) | Microsoft Docs"
---
# Statistical functions

Statistical functions calculate values related to statistical distributions and probability, such as standard deviation and number of permutations.
  
## In this category

|Function  |Description  |
|---------|---------|
|[BETA.DIST](beta-dist-function-dax.md)     |  Returns the beta distribution.        |
|[BETA.INV](beta-inv-function-dax.md)     |  Returns the inverse of the beta cumulative probability density function (BETA.DIST).         |
|[CHISQ.DIST](chisq-dist-function-dax.md)     |  Returns the chi-squared distribution.         |
|[CHISQ.DIST.RT](chisq-dist-rt-function-dax.md)     |  Returns the right-tailed probability of the chi-squared distribution.        |
|[CHISQ.INV](chisq-inv-function-dax.md)     |  Returns the inverse of the left-tailed probability of the chi-squared distribution.         |
|[CHISQ.INV.RT](chisq-inv-rt-function-dax.md)      |  Returns the inverse of the right-tailed probability of the chi-squared distribution.       |
|[COMBIN](combin-function-dax.md)     | Returns the number of combinations for a given number of items.        |
|[COMBINA](combina-function-dax.md)     |  Returns the number of combinations (with repetitions) for a given number of items.        |
|[CONFIDENCE.NORM](confidence-norm-function-dax.md)      | The confidence interval is a range of values.         |
|[CONFIDENCE.T](confidence-t-function-dax.md)      |  Returns the confidence interval for a population mean, using a Student's t distribution.       |
|[EXPON.DIST](expon-dist-function-dax.md)      |  Returns the exponential distribution.        |
|[GEOMEAN](geomean-function-dax.md)     |  Returns the geometric mean of the numbers in a column.        |
|[GEOMEANX](geomeanx-function-dax.md)      | Returns the geometric mean of an expression evaluated for each row in a table.        |
|[LINEST](linest-function-dax.md)|Uses the Least Squares method to calculate a straight line that best fits the given data.|
|[LINESTX](linestx-function-dax.md)|Uses the Least Squares method to calculate a straight line that best fits the given data. The data result from expressions evaluated for each row in a table.|
|[MEDIAN](median-function-dax.md)     |  Returns the median of numbers in a column.       |
|[MEDIANX](medianx-function-dax.md)     |   Returns the median number of an expression evaluated for each row in a table.       |
|[NORM.DIST](norm-dist-function-dax.md)     |  Returns the normal distribution for the specified mean and standard deviation.        |
|[NORM.INV](norm-inv-function-dax.md)       |  The inverse of the normal cumulative distribution for the specified mean and standard deviation.       |
|[NORM.S.DIST](norm-s-dist-function-dax.md)       |  Returns the standard normal distribution (has a mean of zero and a standard deviation of one).       |
|[NORM.S.INV](norm-s-inv-function-dax.md)     |  Returns the inverse of the standard normal cumulative distribution.       |
|[PERCENTILE.EXC](percentile-exc-function-dax.md)     |  Returns the k-th percentile of values in a range, where k is in the range 0..1, exclusive.        |
|[PERCENTILE.INC](percentile-inc-function-dax.md)      |  Returns the k-th percentile of values in a range, where k is in the range 0..1, inclusive.        |
|[PERCENTILEX.EXC](percentilex-exc-function-dax.md)     | Returns the percentile number of an expression evaluated for each row in a table.        |
|[PERCENTILEX.INC](percentilex-inc-function-dax.md)    | Returns the percentile number of an expression evaluated for each row in a table.         |
|[PERMUT](permut-function-dax.md)    | Returns the number of permutations for a given number of objects that can be selected from number objects.        |
|[POISSON.DIST](poisson-dist-function-dax.md)      |  Returns the Poisson distribution.       |
|[RANK.EQ](rank-eq-function-dax.md)    | Returns the ranking of a number in a list of numbers.        |
|[RANKX](rankx-function-dax.md)      | Returns the ranking of a number in a list of numbers for each row in the *table* argument.          |
|[SAMPLE](sample-function-dax.md)       |  Returns a sample of N rows from the specified table.        |
|[STDEV.P](stdev-p-function-dax.md)     |  Returns the standard deviation of the entire population.        |
|[STDEV.S](stdev-s-function-dax.md)      |  Returns the standard deviation of a sample population.        |
|[STDEVX.P](stdevx-p-function-dax.md)      | Returns the standard deviation of the entire population.         |
|[STDEVX.S](stdevx-s-function-dax.md)      |  Returns the standard deviation of a sample population.         |
|[T.DIST](t-dist-function-dax.md)    | Returns the Student's left-tailed t-distribution.        |
|[T.DIST.2T](t-dist-2t-function-dax.md)    | Returns the two-tailed Student's t-distribution.        |
|[T.DIST.RT](t-dist-rt-function-dax.md)     | Returns the right-tailed Student's t-distribution.        |
|[T.INV](t-inv-function-dax.md)     | Returns the left-tailed inverse of the Student's t-distribution.        |
|[T.INV.2t](t-inv-2t-function-dax.md)     | Returns the two-tailed inverse of the Student's t-distribution.        |
|[VAR.P](var-p-function-dax.md)    | Returns the variance of the entire population.         |
|[VAR.S](var-s-function-dax.md)    |  Returns the variance of a sample population.         |
|[VARX.P](varx-p-function-dax.md)     | Returns the variance of the entire population.         |
|[VARX.S](varx-s-function-dax.md)     | Returns the variance of a sample population.        |
